from org.codehaus.jettison.json import JSONObject, JSONArray
from Service import Service
from Component import Component
from Property import Property
from utilities import Util
from WASConfLog import Log;
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ExternallyManagedHTTPServer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExternallyManagedHTTPServer");
  exportedObject.put("roleName", "WebSphereExternallyManagedHTTPServer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externallymanagedhttpserver.name", objid, "name","ExternallyManagedHTTPServer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ExternallyManagedHTTPServer");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "ExternallyManagedHTTPServer");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "ExternallyManagedHTTPServer");
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ExternallyManagedHTTPServer");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ExternallyManagedHTTPServer');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ExternallyManagedHTTPServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExternallyManagedHTTPServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.externallymanagedhttpserver.name", None));
  print "Creating ExternallyManagedHTTPServer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ExternallyManagedHTTPServer", parentid, properties);

  Component.removeComponents(objid, 'components', "ExternallyManagedHTTPServer");
  Service.removeServices(objid, 'services', "ExternallyManagedHTTPServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ExternallyManagedHTTPServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);    
  
  """
  please don't judge me. websphere makes this necessary.
  SERVICES MUST BE IMPORTED BEFORE COMPONENTS(at least top level services)
  ThreadPoolManager MUST BE IMPORTED BEFORE ANY OTHER SERVICES.
  This is mostly caused by references from services/components to ThreadPools. From what I(kensie sturdevant) can tell, all referenced thread pools must exists on the ThreadPoolManager for the server.
  We will then need to pass the "ThreadPool lookup containment path" through to all services/components
  """
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    Log.debug(len(children));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereThreadPoolManager":
        Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
        children.remove(curjsonobject);

    Log.debug(len(children));

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      if (Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath) == 1):
        children.remove(curjsonobject);

    Log.debug(len(children));

    for curjsonobject in children:
      currole = curjsonobject.getString("roleName");
      componentObject = 0;
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('ExternallyManagedHTTPServer');