from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('StreamRedirect')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStreamRedirect");
  exportedObject.put("roleName", "WebSphereStreamRedirect");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.formatwrites", objid, "formatWrites","StreamRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.maxnumberofbackupfiles", objid, "maxNumberOfBackupFiles","StreamRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.suppressstacktrace", objid, "suppressStackTrace","StreamRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.rollovertype", objid, "rolloverType","StreamRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.suppresswrites", objid, "suppressWrites","StreamRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.basehour", objid, "baseHour","StreamRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.filename", objid, "fileName","StreamRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.messageformatkind", objid, "messageFormatKind","StreamRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.rolloversize", objid, "rolloverSize","StreamRedirect");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.streamredirect.rolloverperiod", objid, "rolloverPeriod","StreamRedirect");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StreamRedirect');
  return result;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('StreamRedirect')
  if not jsonobject.has("roleProperties"):
    raise Exception("StreamRedirect resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "formatWrites", roleProperties.optString("websphere.streamredirect.formatwrites", None));
  Util.addIfNotNone(properties, "maxNumberOfBackupFiles", roleProperties.optString("websphere.streamredirect.maxnumberofbackupfiles", None));
  Util.addIfNotNone(properties, "suppressStackTrace", roleProperties.optString("websphere.streamredirect.suppressstacktrace", None));
  Util.addIfNotNone(properties, "rolloverType", roleProperties.optString("websphere.streamredirect.rollovertype", None));
  Util.addIfNotNone(properties, "suppressWrites", roleProperties.optString("websphere.streamredirect.suppresswrites", None));
  Util.addIfNotNone(properties, "baseHour", roleProperties.optString("websphere.streamredirect.basehour", None));
  Util.addIfNotNone(properties, "fileName", roleProperties.optString("websphere.streamredirect.filename", None));
  Util.addIfNotNone(properties, "messageFormatKind", roleProperties.optString("websphere.streamredirect.messageformatkind", None));
  Util.addIfNotNone(properties, "rolloverSize", roleProperties.optString("websphere.streamredirect.rolloversize", None));
  Util.addIfNotNone(properties, "rolloverPeriod", roleProperties.optString("websphere.streamredirect.rolloverperiod", None));
  print "Creating StreamRedirect with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StreamRedirect", parentid, properties, attName);
  Util.popPathElement('StreamRedirect');

  return objid;  

def update(objid,jsonobject):
  Util.pushPathElement('StreamRedirect')
  if not jsonobject.has("roleProperties"):
    raise Exception("StreamRedirect resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.formatwrites", None), "formatWrites","StreamRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.maxnumberofbackupfiles", None), "maxNumberOfBackupFiles","StreamRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.suppressstacktrace", None), "suppressStackTrace","StreamRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.rollovertype", None), "rolloverType","StreamRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.suppresswrites", None), "suppressWrites","StreamRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.basehour", None), "baseHour","StreamRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.filename", None), "fileName","StreamRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.messageformatkind", None), "messageFormatKind","StreamRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.rolloversize", None), "rolloverSize","StreamRedirect");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.streamredirect.rolloverperiod", None), "rolloverPeriod","StreamRedirect");
  if len(atts) != 0:
    print "Modifying StreamRedirect with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StreamRedirect configuration up to date.";

  Util.popPathElement('StreamRedirect');
