from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AdminAgentRegistration')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAdminAgentRegistration");
  exportedObject.put("roleName", "WebSphereAdminAgentRegistration");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminagentregistration.profileroot", objid, "profileRoot","AdminAgentRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminagentregistration.managednodename", objid, "managedNodeName","AdminAgentRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminagentregistration.cellname", objid, "cellName","AdminAgentRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminagentregistration.servername", objid, "serverName","AdminAgentRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminagentregistration.nodename", objid, "nodeName","AdminAgentRegistration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminagentregistration.uuid", objid, "UUID","AdminAgentRegistration");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AdminAgentRegistration');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AdminAgentRegistration')
  if not jsonobject.has("roleProperties"):
    raise Exception("AdminAgentRegistration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "profileRoot", roleProperties.optString("websphere.adminagentregistration.profileroot", None));
  Util.addIfNotNone(properties, "managedNodeName", roleProperties.optString("websphere.adminagentregistration.managednodename", None));
  Util.addIfNotNone(properties, "cellName", roleProperties.optString("websphere.adminagentregistration.cellname", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.adminagentregistration.servername", None));
  Util.addIfNotNone(properties, "nodeName", roleProperties.optString("websphere.adminagentregistration.nodename", None));
  Util.addIfNotNone(properties, "UUID", roleProperties.optString("websphere.adminagentregistration.uuid", None));
  print "Creating AdminAgentRegistration with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AdminAgentRegistration", parentid, properties);
  Util.popPathElement('AdminAgentRegistration');

def update(objid,jsonobject):
  Util.pushPathElement('AdminAgentRegistration')
  if not jsonobject.has("roleProperties"):
    raise Exception("AdminAgentRegistration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminagentregistration.profileroot", None), "profileRoot","AdminAgentRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminagentregistration.managednodename", None), "managedNodeName","AdminAgentRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminagentregistration.cellname", None), "cellName","AdminAgentRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminagentregistration.servername", None), "serverName","AdminAgentRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminagentregistration.nodename", None), "nodeName","AdminAgentRegistration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminagentregistration.uuid", None), "UUID","AdminAgentRegistration");
  if len(atts) != 0:
    print "Modifying AdminAgentRegistration with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AdminAgentRegistration configuration up to date.";

  Util.popPathElement('AdminAgentRegistration');
