from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ApplicationServerClusterMember import ApplicationServerClusterMember

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ApplicationServerClusterMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplicationServerClusterMapping");
  exportedObject.put("roleName", "WebSphereApplicationServerClusterMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationserverclustermapping.applicationname", objid, "applicationName","ApplicationServerClusterMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationserverclustermapping.clustername", objid, "clusterName","ApplicationServerClusterMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationserverclustermapping.cellname", objid, "cellName","ApplicationServerClusterMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationserverclustermapping.transportchain", objid, "transportChain","ApplicationServerClusterMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  applicationServerClusterMembers = Util.parseConfigIdListAttribute(objid, 'applicationServerClusterMembers',"ApplicationServerClusterMapping");
  for applicationServerClusterMember in applicationServerClusterMembers:
    if applicationServerClusterMember is not None and len(applicationServerClusterMember) > 0:
      returndict = Util.createTypeFolder(respath, "ApplicationServerClusterMember", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ApplicationServerClusterMember._export(applicationServerClusterMember, currespath, "Application Server Cluster Member%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ApplicationServerClusterMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ApplicationServerClusterMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerClusterMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "applicationName", roleProperties.optString("websphere.applicationserverclustermapping.applicationname", None));
  Util.addIfNotNone(properties, "clusterName", roleProperties.optString("websphere.applicationserverclustermapping.clustername", None));
  Util.addIfNotNone(properties, "cellName", roleProperties.optString("websphere.applicationserverclustermapping.cellname", None));
  Util.addIfNotNone(properties, "transportChain", roleProperties.optString("websphere.applicationserverclustermapping.transportchain", None));
  print "Creating ApplicationServerClusterMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ApplicationServerClusterMapping", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereApplicationServerClusterMember":
        ApplicationServerClusterMember.create(objid, curjsonobject);
  Util.popPathElement('ApplicationServerClusterMapping');

def update(objid,jsonobject):
  Util.pushPathElement('ApplicationServerClusterMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerClusterMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationserverclustermapping.applicationname", None), "applicationName","ApplicationServerClusterMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationserverclustermapping.clustername", None), "clusterName","ApplicationServerClusterMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationserverclustermapping.cellname", None), "cellName","ApplicationServerClusterMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationserverclustermapping.transportchain", None), "transportChain","ApplicationServerClusterMapping");
  if len(atts) != 0:
    print "Modifying ApplicationServerClusterMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ApplicationServerClusterMapping configuration up to date.";

  applicationServerClusterMembers = Util.parseConfigIdListAttribute(objid, 'applicationServerClusterMembers',"ApplicationServerClusterMapping");
  for applicationServerClusterMember in applicationServerClusterMembers:
    if len(applicationServerClusterMember) > 0:
      Util.remove(applicationServerClusterMember);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereApplicationServerClusterMember":
        ApplicationServerClusterMember.create(objid, curjsonobject);

  Util.popPathElement('ApplicationServerClusterMapping');
