from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ClusterAddressEndPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereClusterAddressEndPoint");
  exportedObject.put("roleName", "WebSphereClusterAddressEndPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteraddressendpoint.port", objid, "port","ClusterAddressEndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteraddressendpoint.name", objid, "name","ClusterAddressEndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteraddressendpoint.enabled", objid, "enabled","ClusterAddressEndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteraddressendpoint.host", objid, "host","ClusterAddressEndPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ClusterAddressEndPoint");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ClusterAddressEndPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ClusterAddressEndPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClusterAddressEndPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.clusteraddressendpoint.port", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.clusteraddressendpoint.name", None));
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.clusteraddressendpoint.enabled", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.clusteraddressendpoint.host", None));
  print "Creating ClusterAddressEndPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ClusterAddressEndPoint", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ClusterAddressEndPoint');


def update(objid,jsonobject):
  Util.pushPathElement('ClusterAddressEndPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClusterAddressEndPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteraddressendpoint.port", None), "port","ClusterAddressEndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteraddressendpoint.name", None), "name","ClusterAddressEndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteraddressendpoint.enabled", None), "enabled","ClusterAddressEndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteraddressendpoint.host", None), "host","ClusterAddressEndPoint");
  if len(atts) != 0:
    print "Modifying ClusterAddressEndPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ClusterAddressEndPoint configuration up to date.";

  Property.removeProperties(objid, 'properties',"ClusterAddressEndPoint");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ClusterAddressEndPoint');
