###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
from DisplayName import DisplayName
from IconType import IconType

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CompatibilityDescriptionGroup')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCompatibilityDescriptionGroup");
  exportedObject.put("roleName", "WebSphereCompatibilityDescriptionGroup");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.compatibilitydescriptiongroup.displayname", objid, "displayName","CompatibilityDescriptionGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.compatibilitydescriptiongroup.largeicon", objid, "largeIcon","CompatibilityDescriptionGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.compatibilitydescriptiongroup.smallicon", objid, "smallIcon","CompatibilityDescriptionGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.compatibilitydescriptiongroup.description", objid, "description","CompatibilityDescriptionGroup");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'CompatibilityDescriptionGroup');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;

  i = 0;
  displayNames = Util.parseConfigIdListAttribute(objid, 'displayNames', 'CompatibilityDescriptionGroup');
  for displayName in displayNames:
    if len(displayName) > 0:
      returndict = Util.createTypeFolder(respath, "DisplayName", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DisplayName._export(displayName, currespath, "DisplayName%s" % i));
      i = i + 1;

  i = 0;
  icons = Util.parseConfigIdListAttribute(objid, 'icons', 'CompatibilityDescriptionGroup');
  for icon in icons:
    if len(icon) > 0:
      returndict = Util.createTypeFolder(respath, "Icon", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, IconType._export(icon, currespath, "Icon%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CompatibilityDescriptionGroup');
  return result;


def create(parentid, jsonobject):
  Util.pushPathElement('CompatibilityDescriptionGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("CompatibilityDescriptionGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "displayName", roleProperties.optString("websphere.compatibilitydescriptiongroup.displayname", None));
  Util.addIfNotNone(properties, "largeIcon", roleProperties.optString("websphere.compatibilitydescriptiongroup.largeicon", None));
  Util.addIfNotNone(properties, "smallIcon", roleProperties.optString("websphere.compatibilitydescriptiongroup.smallicon", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.compatibilitydescriptiongroup.description", None));
  print "Creating CompatibilityDescriptionGroup with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CompatibilityDescriptionGroup", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereDisplayName":
        DisplayName.create(objid, curjsonobject);
      elif currole == "WebSphereIconType":
        IconType.create(objid, curjsonobject);
  Util.popPathElement('CompatibilityDescriptionGroup');

def update(objid,jsonobject):
  Util.pushPathElement('CompatibilityDescriptionGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("CompatibilityDescriptionGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.compatibilitydescriptiongroup.displayname", None), "displayName","CompatibilityDescriptionGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.compatibilitydescriptiongroup.largeicon", None), "largeIcon","CompatibilityDescriptionGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.compatibilitydescriptiongroup.smallicon", None), "smallIcon","CompatibilityDescriptionGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.compatibilitydescriptiongroup.description", None), "description","CompatibilityDescriptionGroup");
  if len(atts) != 0:
    print "Modifying CompatibilityDescriptionGroup with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CompatibilityDescriptionGroup configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'CompatibilityDescriptionGroup');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  displayNames = Util.parseConfigIdListAttribute(objid, 'displayNames', 'CompatibilityDescriptionGroup');
  for displayName in displayNames:
    if len(displayName) > 0:
      Util.remove(displayName);

  icons = Util.parseConfigIdListAttribute(objid, 'icons', 'CompatibilityDescriptionGroup');
  for icon in icons:
    if len(icon) > 0:
      Util.remove(icon);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereDisplayName":
        DisplayName.create(objid, curjsonobject);
      elif currole == "WebSphereIconType":
        IconType.create(objid, curjsonobject);
  Util.popPathElement('CompatibilityDescriptionGroup');
