from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EveryoneExt')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEveryoneExt");
  exportedObject.put("roleName", "WebSphereEveryoneExt");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.everyoneext.name", objid, "name","EveryoneExt");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.everyoneext.accessid", objid, "accessId","EveryoneExt");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EveryoneExt');
  return result;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('EveryoneExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("EveryoneExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.everyoneext.name", None));
  Util.addIfNotNone(properties, "accessId", roleProperties.optString("websphere.everyoneext.accessid", None));
  print "Creating EveryoneExt with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EveryoneExt", parentid, properties, attName);
  Util.popPathElement('EveryoneExt');

def update(objid,jsonobject):
  Util.pushPathElement('EveryoneExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("EveryoneExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.everyoneext.name", None), "name","EveryoneExt");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.everyoneext.accessid", None), "accessId","EveryoneExt");
  if len(atts) != 0:
    print "Modifying EveryoneExt with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EveryoneExt configuration up to date.";

  Util.popPathElement('EveryoneExt');
