from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.jmstransmissionprofile.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'JMSTransmissionProfile');

  containmentpath = "%(parentconpath)sJMSTransmissionProfile:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('JMSTransmissionProfile')

  name = Util.getRequiredAttribute(objid, "name", 'JMSTransmissionProfile');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJMSTransmissionProfile");
  exportedObject.put("roleName", "WebSphereJMSTransmissionProfile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmstransmissionprofile.name", objid, "name","JMSTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmstransmissionprofile.category", objid, "category","JMSTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmstransmissionprofile.queueconnectionfactoryjndiname", objid, "queueConnectionFactoryJNDIName","JMSTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmstransmissionprofile.providertype", objid, "providerType","JMSTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmstransmissionprofile.jndiname", objid, "jndiName","JMSTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmstransmissionprofile.queuejndiname", objid, "queueJNDIName","JMSTransmissionProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmstransmissionprofile.description", objid, "description","JMSTransmissionProfile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JMSTransmissionProfile');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not Util.isValidType("JMSTransmissionProfile", 1):
    return None;
  if not jsonobject.has("roleProperties"):
    raise Exception("JMSTransmissionProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.jmstransmissionprofile.name"):
    raise Exception("Resource role properties does not contain websphere.jmstransmissionprofile.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create JMSTransmissionProfile on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  if not Util.isValidType("JMSTransmissionProfile", 1):
    return None;
  Util.pushPathElement('JMSTransmissionProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("JMSTransmissionProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.jmstransmissionprofile.name"):
    raise Exception("Resource role properties does not contain websphere.jmstransmissionprofile.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jmstransmissionprofile.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.jmstransmissionprofile.category", None));
  Util.addIfNotNone(properties, "queueConnectionFactoryJNDIName", roleProperties.optString("websphere.jmstransmissionprofile.queueconnectionfactoryjndiname", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.jmstransmissionprofile.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.jmstransmissionprofile.jndiname", None));
  Util.addIfNotNone(properties, "queueJNDIName", roleProperties.optString("websphere.jmstransmissionprofile.queuejndiname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.jmstransmissionprofile.description", None));
  print "Creating JMSTransmissionProfile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JMSTransmissionProfile", parentid, properties);
  Util.popPathElement('JMSTransmissionProfile');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('JMSTransmissionProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("JMSTransmissionProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.jmstransmissionprofile.name"):
    raise Exception("Resource role properties does not contain websphere.jmstransmissionprofile.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmstransmissionprofile.name", None), "name","JMSTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmstransmissionprofile.category", None), "category","JMSTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmstransmissionprofile.queueconnectionfactoryjndiname", None), "queueConnectionFactoryJNDIName","JMSTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmstransmissionprofile.providertype", None), "providerType","JMSTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmstransmissionprofile.jndiname", None), "jndiName","JMSTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmstransmissionprofile.queuejndiname", None), "queueJNDIName","JMSTransmissionProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmstransmissionprofile.description", None), "description","JMSTransmissionProfile");
  if len(atts) != 0:
    print "Modifying JMSTransmissionProfile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JMSTransmissionProfile configuration up to date.";

  Util.popPathElement('JMSTransmissionProfile');
