from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MessageCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMessageCondition");
  exportedObject.put("roleName", "WebSphereMessageCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagecondition.type", objid, "type","MessageCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagecondition.value", objid, "value","MessageCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MessageCondition");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MessageCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MessageCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.messagecondition.type", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.messagecondition.value", None));
  print "Creating MessageCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MessageCondition", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MessageCondition');

def update(objid,jsonobject):
  Util.pushPathElement('MessageCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagecondition.type", None), "type","MessageCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagecondition.value", None), "value","MessageCondition");
  if len(atts) != 0:
    print "Modifying MessageCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MessageCondition configuration up to date.";

  Property.removeProperties(objid, 'properties',"MessageCondition");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MessageCondition');
