from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.middlewareappedition.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'MiddlewareAppEdition');

  containmentpath = "%(parentconpath)sMiddlewareAppEdition:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('MiddlewareAppEdition')

  name = Util.getRequiredAttribute(objid, "name", 'MiddlewareAppEdition');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMiddlewareAppEdition");
  exportedObject.put("roleName", "WebSphereMiddlewareAppEdition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareappedition.name", objid, "name","MiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareappedition.alias", objid, "alias","MiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareappedition.description", objid, "description","MiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareappedition.state", objid, "state","MiddlewareAppEdition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MiddlewareAppEdition");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MiddlewareAppEdition');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.middlewareappedition.name"):
    raise Exception("Resource role properties does not contain websphere.middlewareappedition.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MiddlewareAppEdition on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('MiddlewareAppEdition')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.middlewareappedition.name"):
    raise Exception("Resource role properties does not contain websphere.middlewareappedition.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.middlewareappedition.name", None));
  Util.addIfNotNone(properties, "alias", roleProperties.optString("websphere.middlewareappedition.alias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.middlewareappedition.description", None));
  Util.addIfNotNone(properties, "state", roleProperties.optString("websphere.middlewareappedition.state", None));
  print "Creating MiddlewareAppEdition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MiddlewareAppEdition", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MiddlewareAppEdition');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MiddlewareAppEdition')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.middlewareappedition.name"):
    raise Exception("Resource role properties does not contain websphere.middlewareappedition.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareappedition.name", None), "name","MiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareappedition.alias", None), "alias","MiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareappedition.description", None), "description","MiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareappedition.state", None), "state","MiddlewareAppEdition");
  if len(atts) != 0:
    print "Modifying MiddlewareAppEdition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MiddlewareAppEdition configuration up to date.";

  Property.removeProperties(objid, 'properties',"MiddlewareAppEdition");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('MiddlewareAppEdition');
