from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from CookieMapping import CookieMapping

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PassiveAffinityType')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePassiveAffinityType");
  exportedObject.put("roleName", "WebSpherePassiveAffinityType");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.passiveaffinitytype.cookiename", objid, "cookieName","PassiveAffinityType");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  cookieMappings = Util.parseConfigIdListAttribute(objid, 'cookieMappings',"PassiveAffinityType");
  for cookieMapping in cookieMappings:
    if len(cookieMapping) > 0:
      returndict = Util.createTypeFolder(respath, "CookieMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, CookieMapping._export(cookieMapping, currespath, "Cookie Mapping%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PassiveAffinityType');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PassiveAffinityType')
  if not jsonobject.has("roleProperties"):
    raise Exception("PassiveAffinityType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "cookieName", roleProperties.optString("websphere.passiveaffinitytype.cookiename", None));
  print "Creating PassiveAffinityType with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PassiveAffinityType", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereCookieMapping":
        CookieMapping.create(objid, curjsonobject)
  Util.popPathElement('PassiveAffinityType');

def update(objid,jsonobject):
  Util.pushPathElement('PassiveAffinityType')
  if not jsonobject.has("roleProperties"):
    raise Exception("PassiveAffinityType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.passiveaffinitytype.cookiename", None), "cookieName","PassiveAffinityType");
  if len(atts) != 0:
    print "Modifying PassiveAffinityType with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PassiveAffinityType configuration up to date.";

  cookieMappings = Util.parseConfigIdListAttribute(objid, 'cookieMappings',"PassiveAffinityType");
  for cookieMapping in cookieMappings:
    if len(cookieMapping) > 0:
      Util.remove(cookieMapping);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereCookieMapping":
        CookieMapping.create(objid, curjsonobject)



  Util.popPathElement('PassiveAffinityType');
