###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from AdminObject import AdminObject
from AuthenticationMechanism import AuthenticationMechanism
from ConfigProperty import ConfigProperty
from InboundResourceAdapter import InboundResourceAdapter
from OutboundResourceAdapter import OutboundResourceAdapter
from SecurityPermission import SecurityPermission

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ResourceAdapter')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereResourceAdapter");
  exportedObject.put("roleName", "WebSphereResourceAdapter");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceadapter.reauthenticationsupport", objid, "reauthenticationSupport","ResourceAdapter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceadapter.connectionfactoryimplclass", objid, "connectionFactoryImplClass","ResourceAdapter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceadapter.managedconnectionfactoryclass", objid, "managedConnectionFactoryClass","ResourceAdapter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceadapter.connectioninterface", objid, "connectionInterface","ResourceAdapter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceadapter.resourceadapterclass", objid, "resourceAdapterClass","ResourceAdapter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceadapter.transactionsupport", objid, "transactionSupport","ResourceAdapter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceadapter.connectionimplclass", objid, "connectionImplClass","ResourceAdapter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceadapter.connectionfactoryinterface", objid, "connectionFactoryInterface","ResourceAdapter");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  inboundRAdapter = Util.getOptionalAttribute(objid, 'inboundResourceAdapter', 'ResourceAdapter');
  if inboundRAdapter is not None and len(inboundRAdapter) > 0:
    returndict = Util.createTypeFolder(respath, "InboundResourceAdapter", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, InboundResourceAdapter._export(inboundRAdapter, currespath, "Inbound Resource Adapter"));

  outboundRAdapter = Util.getOptionalAttribute(objid, 'outboundResourceAdapter', 'ResourceAdapter');
  if outboundRAdapter is not None and len(outboundRAdapter) > 0:
    returndict = Util.createTypeFolder(respath, "OutboundResourceAdapter", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, OutboundResourceAdapter._export(outboundRAdapter, currespath, "Outbound Resource Adapter"));

  i = 0;
  adminObjs = Util.parseConfigIdListAttribute(objid, 'adminObjects', 'ResourceAdapter');
  for adminObj in adminObjs:
    if len(adminObj) > 0:
      returndict = Util.createTypeFolder(respath, "AdminObject", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, AdminObject._export(adminObj, currespath, "AdminObject%s" % i));
      i = i + 1;

  i = 0;
  mechanisms = Util.parseConfigIdListAttribute(objid, 'authenticationMechanisms', 'ResourceAdapter');
  for mech in mechanisms:
    if len(mech) > 0:
      returndict = Util.createTypeFolder(respath, "AuthenticationMechanism", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, AuthenticationMechanism._export(mech, currespath, "AuthenticationMechanism%s" % i));
      i = i + 1;

  i = 0;
  properties = Util.parseConfigIdListAttribute(objid, 'configProperties', 'ResourceAdapter');
  for prop in properties:
    if len(prop) > 0:
      returndict = Util.createTypeFolder(respath, "ConfigProperty", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ConfigProperty._export(prop, currespath, "ConfigProperty%s" % i));
      i = i + 1;

  i = 0;
  secPerms = Util.parseConfigIdListAttribute(objid, 'securityPermissions', 'ResourceAdapter');
  for secPerm in secPerms:
    if len(secPerm) > 0:
      returndict = Util.createTypeFolder(respath, "SecurityPermission", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SecurityPermission._export(secPerm, currespath, "SecurityPermission%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ResourceAdapter');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ResourceAdapter')
  if not jsonobject.has("roleProperties"):
    raise Exception("ResourceAdapter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "reauthenticationSupport", roleProperties.optString("websphere.resourceadapter.reauthenticationsupport", None));
  Util.addIfNotNone(properties, "connectionFactoryImplClass", roleProperties.optString("websphere.resourceadapter.connectionfactoryimplclass", None));
  Util.addIfNotNone(properties, "managedConnectionFactoryClass", roleProperties.optString("websphere.resourceadapter.managedconnectionfactoryclass", None));
  Util.addIfNotNone(properties, "connectionInterface", roleProperties.optString("websphere.resourceadapter.connectioninterface", None));
  Util.addIfNotNone(properties, "resourceAdapterClass", roleProperties.optString("websphere.resourceadapter.resourceadapterclass", None));
  Util.addIfNotNone(properties, "transactionSupport", roleProperties.optString("websphere.resourceadapter.transactionsupport", None));
  Util.addIfNotNone(properties, "connectionImplClass", roleProperties.optString("websphere.resourceadapter.connectionimplclass", None));
  Util.addIfNotNone(properties, "connectionFactoryInterface", roleProperties.optString("websphere.resourceadapter.connectionfactoryinterface", None));
  print "Creating ResourceAdapter with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ResourceAdapter", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereAdminObject":
        AdminObject.create(objid, curjsonobject);
      elif currole == "WebSphereAuthenticationMechanism":
        AuthenticationMechanism.create(objid, curjsonobject);
      elif currole == "WebSphereConfigProperty":
        ConfigProperty.create(objid, curjsonobject);
      elif currole == "WebSphereInboundResourceAdapter":
        InboundResourceAdapter.create(objid, curjsonobject);
      elif currole == "WebSphereOutboundResourceAdapter":
        OutboundResourceAdapter.create(objid, curjsonobject);
      elif currole == "WebSphereSecurityPermission":
        SecurityPermission.create(objid, curjsonobject);
  Util.popPathElement('ResourceAdapter');

def update(objid,jsonobject):
  Util.pushPathElement('ResourceAdapter')
  if not jsonobject.has("roleProperties"):
    raise Exception("ResourceAdapter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceadapter.reauthenticationsupport", None), "reauthenticationSupport","ResourceAdapter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceadapter.connectionfactoryimplclass", None), "connectionFactoryImplClass","ResourceAdapter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceadapter.managedconnectionfactoryclass", None), "managedConnectionFactoryClass","ResourceAdapter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceadapter.connectioninterface", None), "connectionInterface","ResourceAdapter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceadapter.resourceadapterclass", None), "resourceAdapterClass","ResourceAdapter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceadapter.transactionsupport", None), "transactionSupport","ResourceAdapter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceadapter.connectionimplclass", None), "connectionImplClass","ResourceAdapter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceadapter.connectionfactoryinterface", None), "connectionFactoryInterface","ResourceAdapter");
  if len(atts) != 0:
    print "Modifying ResourceAdapter with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ResourceAdapter configuration up to date.";

  inboundRAdapter = Util.getOptionalAttribute(objid, 'inboundResourceAdapter', 'ResourceAdapter');
  if inboundRAdapter is not None and len(inboundRAdapter) > 0:
    Util.remove(inboundRAdapter);

  outboundRAdapter = Util.getOptionalAttribute(objid, 'outboundResourceAdapter', 'ResourceAdapter');
  if outboundRAdapter is not None and len(outboundRAdapter) > 0:
    Util.remove(outboundRAdapter);

  adminObjs = Util.parseConfigIdListAttribute(objid, 'adminObjects', 'ResourceAdapter');
  for adminObj in adminObjs:
    if len(adminObj) > 0:
      Util.remove(adminObj);

  mechanisms = Util.parseConfigIdListAttribute(objid, 'authenticationMechanisms', 'ResourceAdapter');
  for mech in mechanisms:
    if len(mech) > 0:
      Util.remove(mech);

  properties = Util.parseConfigIdListAttribute(objid, 'configProperties', 'ResourceAdapter');
  for prop in properties:
    if len(prop) > 0:
      Util.remove(prop);

  secPerms = Util.parseConfigIdListAttribute(objid, 'securityPermissions', 'ResourceAdapter');
  for secPerm in secPerms:
    if len(secPerm) > 0:
      Util.remove(secPerm);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereAdminObject":
        AdminObject.create(objid, curjsonobject);
      elif currole == "WebSphereAuthenticationMechanism":
        AuthenticationMechanism.create(objid, curjsonobject);
      elif currole == "WebSphereConfigProperty":
        ConfigProperty.create(objid, curjsonobject);
      elif currole == "WebSphereInboundResourceAdapter":
        InboundResourceAdapter.create(objid, curjsonobject);
      elif currole == "WebSphereOutboundResourceAdapter":
        OutboundResourceAdapter.create(objid, curjsonobject);
      elif currole == "WebSphereSecurityPermission":
        SecurityPermission.create(objid, curjsonobject);

  Util.popPathElement('ResourceAdapter');
