from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ServerTarget')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereServerTarget");
  exportedObject.put("roleName", "WebSphereServerTarget");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.servertarget.name", objid, "name","ServerTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.servertarget.nodename", objid, "nodeName","ServerTarget");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ServerTarget');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ServerTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServerTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.servertarget.name", None));
  Util.addIfNotNone(properties, "nodeName", roleProperties.optString("websphere.servertarget.nodename", None));
  print "Creating ServerTarget with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ServerTarget", parentid, properties);
  Util.popPathElement('ServerTarget');

def update(objid,jsonobject):
  Util.pushPathElement('ServerTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServerTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.servertarget.name", None), "name","ServerTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.servertarget.nodename", None), "nodeName","ServerTarget");
  if len(atts) != 0:
    print "Modifying ServerTarget with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ServerTarget configuration up to date.";

  Util.popPathElement('ServerTarget');
