from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Service import Service
from Component import Component
from utilities import Util
from Property import Property
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SystemMessageServer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSystemMessageServer");
  exportedObject.put("roleName", "WebSphereSystemMessageServer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.systemmessageserver.name", objid, "name","SystemMessageServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.systemmessageserver.brokername", objid, "brokerName","SystemMessageServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.systemmessageserver.domainname", objid, "domainName","SystemMessageServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.systemmessageserver.enable", objid, "enable","SystemMessageServer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SystemMessageServer");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "SystemMessageServer");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "SystemMessageServer");
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"SystemMessageServer");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SystemMessageServer');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('SystemMessageServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("SystemMessageServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.systemmessageserver.name", None));
  Util.addIfNotNone(properties, "brokerName", roleProperties.optString("websphere.systemmessageserver.brokername", None));
  Util.addIfNotNone(properties, "domainName", roleProperties.optString("websphere.systemmessageserver.domainname", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.systemmessageserver.enable", None));
  print "Creating SystemMessageServer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SystemMessageServer", parentid, properties);

  Property.removeProperties(objid, 'properties',"SystemMessageServer");
  Component.removeComponents(objid, 'components', "SystemMessageServer");
  Service.removeServices(objid, 'services', "SystemMessageServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"SystemMessageServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);  
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);
  Util.popPathElement('SystemMessageServer');
        

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('SystemMessageServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("SystemMessageServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.systemmessageserver.name", None), "name","SystemMessageServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.systemmessageserver.brokername", None), "brokerName","SystemMessageServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.systemmessageserver.domainname", None), "domainName","SystemMessageServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.systemmessageserver.enable", None), "enable","SystemMessageServer");
  if len(atts) != 0:
    print "Modifying SystemMessageServer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SystemMessageServer configuration up to date.";

  Property.removeProperties(objid, 'properties',"SystemMessageServer");
  Component.removeComponents(objid, 'components', "SystemMessageServer");
  Service.removeServices(objid, 'services', "SystemMessageServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"SystemMessageServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);    
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('SystemMessageServer');
