from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASResourceEnvRefBinding')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASResourceEnvRefBinding");
  exportedObject.put("roleName", "WebSphereWASResourceEnvRefBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasresourceenvrefbinding.jndiname", objid, "jndiName","WASResourceEnvRefBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASResourceEnvRefBinding');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASResourceEnvRefBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASResourceEnvRefBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.wasresourceenvrefbinding.jndiname", None));
  print "Creating WASResourceEnvRefBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASResourceEnvRefBinding", parentid, properties);
  Util.popPathElement('WASResourceEnvRefBinding');

def update(objid,jsonobject):
  Util.pushPathElement('WASResourceEnvRefBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASResourceEnvRefBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasresourceenvrefbinding.jndiname", None), "jndiName","WASResourceEnvRefBinding");
  if len(atts) != 0:
    print "Modifying WASResourceEnvRefBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASResourceEnvRefBinding configuration up to date.";

  Util.popPathElement('WASResourceEnvRefBinding');
