from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WLMCoreGroupBridgePlugin')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWLMCoreGroupBridgePlugin");
  exportedObject.put("roleName", "WebSphereWLMCoreGroupBridgePlugin");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.wlmcoregroupbridgeplugin.hostdonottranslatelist", objid, "hostDoNotTranslateList","WLMCoreGroupBridgePlugin");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wlmcoregroupbridgeplugin.coregroup", objid, "coreGroup","WLMCoreGroupBridgePlugin");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.wlmcoregroupbridgeplugin.hosttranslatelist", objid, "hostTranslateList","WLMCoreGroupBridgePlugin");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WLMCoreGroupBridgePlugin");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WLMCoreGroupBridgePlugin');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WLMCoreGroupBridgePlugin')
  if not jsonobject.has("roleProperties"):
    raise Exception("WLMCoreGroupBridgePlugin resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "hostDoNotTranslateList", roleProperties.optString("websphere.wlmcoregroupbridgeplugin.hostdonottranslatelist", None));
  Util.addIfNotNone(properties, "coreGroup", roleProperties.optString("websphere.wlmcoregroupbridgeplugin.coregroup", None));
  Util.addPathProperty(properties, "hostTranslateList", roleProperties.optString("websphere.wlmcoregroupbridgeplugin.hosttranslatelist", None));
  print "Creating WLMCoreGroupBridgePlugin with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WLMCoreGroupBridgePlugin", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WLMCoreGroupBridgePlugin');

def update(objid,jsonobject):
  Util.pushPathElement('WLMCoreGroupBridgePlugin')
  if not jsonobject.has("roleProperties"):
    raise Exception("WLMCoreGroupBridgePlugin resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.wlmcoregroupbridgeplugin.hostdonottranslatelist", None), "hostDoNotTranslateList","WLMCoreGroupBridgePlugin");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wlmcoregroupbridgeplugin.coregroup", None), "coreGroup","WLMCoreGroupBridgePlugin");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.wlmcoregroupbridgeplugin.hosttranslatelist", None), "hostTranslateList","WLMCoreGroupBridgePlugin");
  if len(atts) != 0:
    print "Modifying WLMCoreGroupBridgePlugin with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WLMCoreGroupBridgePlugin configuration up to date.";

  Property.removeProperties(objid, 'properties',"WLMCoreGroupBridgePlugin");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WLMCoreGroupBridgePlugin');
