from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSGWInstance')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSGWInstance");
  exportedObject.put("roleName", "WebSphereWSGWInstance");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwinstance.name", objid, "name","WSGWInstance");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwinstance.description", objid, "description","WSGWInstance");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwinstance.wsdlservicenamespace", objid, "wsdlServiceNamespace","WSGWInstance");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSGWInstance');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSGWInstance')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSGWInstance resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wsgwinstance.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.wsgwinstance.description", None));
  Util.addIfNotNone(properties, "wsdlServiceNamespace", roleProperties.optString("websphere.wsgwinstance.wsdlservicenamespace", None));
  print "Creating WSGWInstance with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSGWInstance", parentid, properties);
  Util.popPathElement('WSGWInstance');

def update(objid,jsonobject):
  Util.pushPathElement('WSGWInstance')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSGWInstance resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwinstance.name", None), "name","WSGWInstance");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwinstance.description", None), "description","WSGWInstance");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwinstance.wsdlservicenamespace", None), "wsdlServiceNamespace","WSGWInstance");
  if len(atts) != 0:
    print "Modifying WSGWInstance with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSGWInstance configuration up to date.";

  Util.popPathElement('WSGWInstance');
