from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Preferences')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePreferences");
  exportedObject.put("roleName", "WebSpherePreferences");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.preferences.name", objid, "name","Preferences");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.preferences.scope", objid, "scope","Preferences");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Preferences');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Preferences')
  if not jsonobject.has("roleProperties"):
    raise Exception("Preferences resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.preferences.name", None));
  Util.addIfNotNone(properties, "scope", roleProperties.optString("websphere.preferences.scope", None));
  print "Creating Preferences with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Preferences", parentid, properties);
  Util.popPathElement('Preferences');

def update(objid,jsonobject):
  Util.pushPathElement('Preferences')
  if not jsonobject.has("roleProperties"):
    raise Exception("Preferences resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.preferences.name", None), "name","Preferences");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.preferences.scope", None), "scope","Preferences");
  if len(atts) != 0:
    print "Modifying Preferences with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Preferences configuration up to date.";

  Util.popPathElement('Preferences');
