from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('StuckRequestCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStuckRequestCondition");
  exportedObject.put("roleName", "WebSphereStuckRequestCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.stuckrequestcondition.timeoutpercent", objid, "timeoutPercent","StuckRequestCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.stuckrequestcondition.name", objid, "name","StuckRequestCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.stuckrequestcondition.conditionexpr", objid, "conditionExpr","StuckRequestCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StuckRequestCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('StuckRequestCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("StuckRequestCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "timeoutPercent", roleProperties.optString("websphere.stuckrequestcondition.timeoutpercent", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.stuckrequestcondition.name", None));
  Util.addIfNotNone(properties, "conditionExpr", roleProperties.optString("websphere.stuckrequestcondition.conditionexpr", None));
  print "Creating StuckRequestCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StuckRequestCondition", parentid, properties);
  Util.popPathElement('StuckRequestCondition');

def update(objid,jsonobject):
  Util.pushPathElement('StuckRequestCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("StuckRequestCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.stuckrequestcondition.timeoutpercent", None), "timeoutPercent","StuckRequestCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.stuckrequestcondition.name", None), "name","StuckRequestCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.stuckrequestcondition.conditionexpr", None), "conditionExpr","StuckRequestCondition");
  if len(atts) != 0:
    print "Modifying StuckRequestCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StuckRequestCondition configuration up to date.";

  Util.popPathElement('StuckRequestCondition');

def getStuckRequestCondition(objid):
  stuckRequestCondition = Util.getAssociatedObjects(objid, "StuckRequestCondition");
  return stuckRequestCondition;
