from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASHandlerChain')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASHandlerChain");
  exportedObject.put("roleName", "WebSphereWASHandlerChain");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.washandlerchain.protocolbindings", objid, "protocolBindings","WASHandlerChain");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASHandlerChain');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASHandlerChain')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASHandlerChain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "protocolBindings", roleProperties.optString("websphere.washandlerchain.protocolbindings", None));
  print "Creating WASHandlerChain with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASHandlerChain", parentid, properties);
  Util.popPathElement('WASHandlerChain');

def update(objid,jsonobject):
  Util.pushPathElement('WASHandlerChain')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASHandlerChain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.washandlerchain.protocolbindings", None), "protocolBindings","WASHandlerChain");
  if len(atts) != 0:
    print "Modifying WASHandlerChain with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASHandlerChain configuration up to date.";

  Util.popPathElement('WASHandlerChain');
