from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AutonomicRequestFlowManager')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAutonomicRequestFlowManager");
  exportedObject.put("roleName", "WebSphereAutonomicRequestFlowManager");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.autonomicrequestflowmanager.aggregationperiod", objid, "aggregationPeriod","AutonomicRequestFlowManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.autonomicrequestflowmanager.rejectionthreshold", objid, "rejectionThreshold","AutonomicRequestFlowManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.autonomicrequestflowmanager.aggregationperiodunits", objid, "aggregationPeriodUnits","AutonomicRequestFlowManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.autonomicrequestflowmanager.maximumpercentservermaxheap", objid, "maximumPercentServerMaxHeap","AutonomicRequestFlowManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.autonomicrequestflowmanager.maximumqueuelength", objid, "maximumQueueLength","AutonomicRequestFlowManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.autonomicrequestflowmanager.maximumcpuutilization", objid, "maximumCPUUtilization","AutonomicRequestFlowManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.autonomicrequestflowmanager.controlcycleminimumlengthunits", objid, "controlCycleMinimumLengthUnits","AutonomicRequestFlowManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.autonomicrequestflowmanager.smoothingwindow", objid, "smoothingWindow","AutonomicRequestFlowManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.autonomicrequestflowmanager.controlcycleminimumlength", objid, "controlCycleMinimumLength","AutonomicRequestFlowManager");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AutonomicRequestFlowManager");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AutonomicRequestFlowManager');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AutonomicRequestFlowManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("AutonomicRequestFlowManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "aggregationPeriod", roleProperties.optString("websphere.autonomicrequestflowmanager.aggregationperiod", None));
  Util.addIfNotNone(properties, "rejectionThreshold", roleProperties.optString("websphere.autonomicrequestflowmanager.rejectionthreshold", None));
  Util.addIfNotNone(properties, "aggregationPeriodUnits", roleProperties.optString("websphere.autonomicrequestflowmanager.aggregationperiodunits", None));
  Util.addIfNotNone(properties, "maximumPercentServerMaxHeap", roleProperties.optString("websphere.autonomicrequestflowmanager.maximumpercentservermaxheap", None));
  Util.addIfNotNone(properties, "maximumQueueLength", roleProperties.optString("websphere.autonomicrequestflowmanager.maximumqueuelength", None));
  Util.addIfNotNone(properties, "maximumCPUUtilization", roleProperties.optString("websphere.autonomicrequestflowmanager.maximumcpuutilization", None));
  Util.addIfNotNone(properties, "controlCycleMinimumLengthUnits", roleProperties.optString("websphere.autonomicrequestflowmanager.controlcycleminimumlengthunits", None));
  Util.addIfNotNone(properties, "smoothingWindow", roleProperties.optString("websphere.autonomicrequestflowmanager.smoothingwindow", None));
  Util.addIfNotNone(properties, "controlCycleMinimumLength", roleProperties.optString("websphere.autonomicrequestflowmanager.controlcycleminimumlength", None));
  print "Creating AutonomicRequestFlowManager with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AutonomicRequestFlowManager", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AutonomicRequestFlowManager');


def update(objid,jsonobject):
  Util.pushPathElement('AutonomicRequestFlowManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("AutonomicRequestFlowManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.autonomicrequestflowmanager.aggregationperiod", None), "aggregationPeriod","AutonomicRequestFlowManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.autonomicrequestflowmanager.rejectionthreshold", None), "rejectionThreshold","AutonomicRequestFlowManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.autonomicrequestflowmanager.aggregationperiodunits", None), "aggregationPeriodUnits","AutonomicRequestFlowManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.autonomicrequestflowmanager.maximumpercentservermaxheap", None), "maximumPercentServerMaxHeap","AutonomicRequestFlowManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.autonomicrequestflowmanager.maximumqueuelength", None), "maximumQueueLength","AutonomicRequestFlowManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.autonomicrequestflowmanager.maximumcpuutilization", None), "maximumCPUUtilization","AutonomicRequestFlowManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.autonomicrequestflowmanager.controlcycleminimumlengthunits", None), "controlCycleMinimumLengthUnits","AutonomicRequestFlowManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.autonomicrequestflowmanager.smoothingwindow", None), "smoothingWindow","AutonomicRequestFlowManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.autonomicrequestflowmanager.controlcycleminimumlength", None), "controlCycleMinimumLength","AutonomicRequestFlowManager");
  if len(atts) != 0:
    print "Modifying AutonomicRequestFlowManager with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AutonomicRequestFlowManager configuration up to date.";

  Property.removeProperties(objid, 'properties',"AutonomicRequestFlowManager");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AutonomicRequestFlowManager');
