from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from J2EEResourceProperty import J2EEResourceProperty
from ConnectionDefinitionRef import ConnectionDefinitionRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ConnectionDefTemplateProps')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereConnectionDefTemplateProps");
  exportedObject.put("roleName", "WebSphereConnectionDefTemplateProps");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  connDefinition = Util.getRequiredAttribute(objid, 'ConnectionDefinition', 'ConnectionDefTemplateProps');
  if connDefinition is not None and len(connDefinition) > 0:
    returndict = Util.createTypeFolder(respath, "ConnectionDefinitionRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ConnectionDefinitionRef._export(connDefinition, currespath, 'Connection Definition'));

  resourceProperties = Util.parseConfigIdListAttribute(objid, 'resourceProperties', 'ConnectionDefTemplateProps');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      returndict = Util.createTypeFolder(respath, "J2EEResourceProperty", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, J2EEResourceProperty._export(resprop, currespath));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ConnectionDefTemplateProps');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ConnectionDefTemplateProps')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectionDefTemplateProps resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating ConnectionDefTemplateProps with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ConnectionDefTemplateProps", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
      elif currole == "WebSphereConnectionDefinitionRef":
        ConnectionDefinitionRef.create(objid, curjsonobject, "ConnectionDefinition", "ConnectionDefTemplateProps");
  Util.popPathElement('ConnectionDefTemplateProps');

def update(objid,jsonobject):
  Util.pushPathElement('ConnectionDefTemplateProps')
  if not jsonobject.has("roleProperties"):
    raise Exception("ConnectionDefTemplateProps resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying ConnectionDefTemplateProps with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ConnectionDefTemplateProps configuration up to date.";

  Util.unsetAttribute(objid, 'ConnectionDefinition',"ConnectionDefTemplateProps");

  resourceProperties = Util.parseConfigIdListAttribute(objid, 'resourceProperties', 'ConnectionDefTemplateProps');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      Util.remove(resprop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
      elif currole == "WebSphereConnectionDefinitionRef":
        ConnectionDefinitionRef.create(objid, curjsonobject, "ConnectionDefinition", "ConnectionDefTemplateProps");
  Util.popPathElement('ConnectionDefTemplateProps');
