from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DebugService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDebugService");
  exportedObject.put("roleName", "WebSphereDebugService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.debugservice.bsfdebugport", objid, "BSFDebugPort","DebugService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.debugservice.enable", objid, "enable","DebugService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.debugservice.jvmdebugport", objid, "jvmDebugPort","DebugService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.debugservice.jvmdebugargs", objid, "jvmDebugArgs","DebugService");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.debugservice.debugclassfilters", objid, "debugClassFilters","DebugService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.debugservice.bsflogginglevel", objid, "BSFLoggingLevel","DebugService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DebugService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DebugService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('DebugService')
  if not jsonobject.has("roleProperties"):
    raise Exception("DebugService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "BSFDebugPort", roleProperties.optString("websphere.debugservice.bsfdebugport", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.debugservice.enable", None));
  Util.addIfNotNone(properties, "jvmDebugPort", roleProperties.optString("websphere.debugservice.jvmdebugport", None));
  Util.addIfNotNone(properties, "jvmDebugArgs", roleProperties.optString("websphere.debugservice.jvmdebugargs", None));
  Util.addPathProperty(properties, "debugClassFilters", roleProperties.optString("websphere.debugservice.debugclassfilters", None));
  Util.addIfNotNone(properties, "BSFLoggingLevel", roleProperties.optString("websphere.debugservice.bsflogginglevel", None));
  print "Creating DebugService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DebugService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DebugService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('DebugService')
  if not jsonobject.has("roleProperties"):
    raise Exception("DebugService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.debugservice.bsfdebugport", None), "BSFDebugPort","DebugService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.debugservice.enable", None), "enable","DebugService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.debugservice.jvmdebugport", None), "jvmDebugPort","DebugService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.debugservice.jvmdebugargs", None), "jvmDebugArgs","DebugService");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.debugservice.debugclassfilters", None), "debugClassFilters","DebugService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.debugservice.bsflogginglevel", None), "BSFLoggingLevel","DebugService");
  if len(atts) != 0:
    print "Modifying DebugService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DebugService configuration up to date.";

  Property.removeProperties(objid, 'properties',"DebugService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DebugService');
