from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from DescriptivePropertyGroup import DescriptivePropertyGroup

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DescriptivePropertyGroup')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDescriptivePropertyGroup");
  exportedObject.put("roleName", "WebSphereDescriptivePropertyGroup");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptivepropertygroup.expandable", objid, "expandable","DescriptivePropertyGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptivepropertygroup.name", objid, "name","DescriptivePropertyGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptivepropertygroup.template", objid, "template","DescriptivePropertyGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.descriptivepropertygroup.collection", objid, "collection","DescriptivePropertyGroup");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  propertygroups = Util.parseConfigIdListAttribute(objid, 'propertyGroups',"DescriptivePropertyGroup");
  for propertygroup in propertygroups:
    if len(propertygroup) > 0:
      returndict = Util.createTypeFolder(respath, "DescriptivePropertyGroup", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, _export(propertygroup, currespath, "PropertyGroup%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DescriptivePropertyGroup');
  return result;

def create(parentid, jsonobject):
  Util.pushPathElement('DescriptivePropertyGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("DescriptivePropertyGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "expandable", roleProperties.optString("websphere.descriptivepropertygroup.expandable", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.descriptivepropertygroup.name", None));
  Util.addIfNotNone(properties, "template", roleProperties.optString("websphere.descriptivepropertygroup.template", None));
  Util.addIfNotNone(properties, "collection", roleProperties.optString("websphere.descriptivepropertygroup.collection", None));
  print "Creating DescriptivePropertyGroup with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DescriptivePropertyGroup", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescriptivePropertyGroup":
        DescriptivePropertyGroup.create(objid, curjsonobject);
  Util.popPathElement('DescriptivePropertyGroup');

def update(objid,jsonobject):
  Util.pushPathElement('DescriptivePropertyGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("DescriptivePropertyGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptivepropertygroup.expandable", None), "expandable","DescriptivePropertyGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptivepropertygroup.name", None), "name","DescriptivePropertyGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptivepropertygroup.template", None), "template","DescriptivePropertyGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.descriptivepropertygroup.collection", None), "collection","DescriptivePropertyGroup");
  if len(atts) != 0:
    print "Modifying DescriptivePropertyGroup with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DescriptivePropertyGroup configuration up to date.";

  propertygroups = Util.parseConfigIdListAttribute(objid, 'propertyGroups',"DescriptivePropertyGroup");
  for propertygroup in propertygroups:
    if len(propertygroup) > 0:
      Util.remove(propertygroup);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescriptivePropertyGroup":
        DescriptivePropertyGroup.create(objid, curjsonobject);
  Util.popPathElement('DescriptivePropertyGroup');
