from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Interceptor')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereInterceptor");
  exportedObject.put("roleName", "WebSphereInterceptor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.interceptor.name", objid, "name","Interceptor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Interceptor');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Interceptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("Interceptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.interceptor.name", None));
  print "Creating Interceptor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Interceptor", parentid, properties);
  Util.popPathElement('Interceptor');

def update(objid,jsonobject):
  Util.pushPathElement('Interceptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("Interceptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.interceptor.name", None), "name","Interceptor");
  if len(atts) != 0:
    print "Modifying Interceptor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Interceptor configuration up to date.";

  Util.popPathElement('Interceptor');
