from org.codehaus.jettison.json import JSONObject, JSONArray
from Service import Service
from Component import Component
from Property import Property
from utilities import Util
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JMSServer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJMSServer");
  exportedObject.put("roleName", "WebSphereJMSServer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmsserver.name", objid, "name","JMSServer");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.jmsserver.queuenames", objid, "queueNames","JMSServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmsserver.description", objid, "description","JMSServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmsserver.numthreads", objid, "numThreads","JMSServer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"JMSServer");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "JMSServer");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "JMSServer");
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"JMSServer");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JMSServer');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('JMSServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("JMSServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jmsserver.name", None));
  Util.addPathProperty(properties, "queueNames", roleProperties.optString("websphere.jmsserver.queuenames", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.jmsserver.description", None));
  Util.addIfNotNone(properties, "numThreads", roleProperties.optString("websphere.jmsserver.numthreads", None));
  print "Creating JMSServer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JMSServer", parentid, properties);

  Component.removeComponents(objid, 'components', "JMSServer");
  Property.removeProperties(objid, 'properties',"JMSServer");
  Service.removeServices(objid, 'services', "JMSServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"JMSServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);     
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);                
  Util.popPathElement('JMSServer');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('JMSServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("JMSServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmsserver.name", None), "name","JMSServer");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.jmsserver.queuenames", None), "queueNames","JMSServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmsserver.description", None), "description","JMSServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmsserver.numthreads", None), "numThreads","JMSServer");
  if len(atts) != 0:
    print "Modifying JMSServer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JMSServer configuration up to date.";

  Property.removeProperties(objid, 'properties',"JMSServer");
  Component.removeComponents(objid, 'components', "JMSServer");
  Service.removeServices(objid, 'services', "JMSServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"JMSServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);     
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('JMSServer');
