from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthGroupRef import SIBAuthGroupRef;
from SIBAuthUserRef import SIBAuthUserRef;


__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthBusConnect')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthBusConnect");
  exportedObject.put("roleName", "WebSphereSIBAuthBusConnect");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  groups = Util.parseConfigIdListAttribute(objid, 'group', 'SIBAuthCreator');
  for group in groups:
    if len(group) > 0:
      returndict = Util.createTypeFolder(respath, "SIBAuthGroupRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBAuthGroupRef._export(group, currespath, "SIBAuthGroupRef%s" % i));
      i = i + 1;

  i = 0;
  users = Util.parseConfigIdListAttribute(objid, 'user', 'SIBAuthCreator');
  for user in users:
    if len(user) > 0:
      returndict = Util.createTypeFolder(respath, "SIBAuthUserRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBAuthUserRef._export(user, currespath, "SIBAuthUserRef%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthBusConnect');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthBusConnect')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthBusConnect resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating SIBAuthBusConnect with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthBusConnect", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthGroupRef":
        SIBAuthGroupRef.create(objid, curjsonobject, 'group');
      elif currole == "WebSphereSIBAuthUserRef":
        SIBAuthUserRef.create(objid, curjsonobject, 'user');

  Util.popPathElement('SIBAuthBusConnect');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthBusConnect')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthBusConnect resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying SIBAuthBusConnect with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthBusConnect configuration up to date.";

  Util.unsetAttribute(objid, "group", "SIBAuthIdentityAdopter");
  Util.unsetAttribute(objid, "user", "SIBAuthIdentityAdopter");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthGroupRef":
        SIBAuthGroupRef.create(objid, curjsonobject, 'group');
      elif currole == "WebSphereSIBAuthUserRef":
        SIBAuthUserRef.create(objid, curjsonobject, 'user');

  Util.popPathElement('SIBAuthBusConnect');
