from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
import re

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecurityPermission')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecurityPermission");
  exportedObject.put("roleName", "WebSphereSecurityPermission");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitypermission.specification", objid, "specification","SecurityPermission");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitypermission.description", objid, "description","SecurityPermission");

  #This is to filter out any strange extra whitespace characters such as \t and \n
  specString = roleProperties.optString("websphere.securitypermission.specification");
  specString = re.sub('\s+', ' ', specString);
  specString = specString.strip();
  roleProperties.put("websphere.securitypermission.specification", specString);

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'SecurityPermission');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecurityPermission');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecurityPermission')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityPermission resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "specification", roleProperties.optString("websphere.securitypermission.specification", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.securitypermission.description", None));
  print "Creating SecurityPermission with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecurityPermission", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('SecurityPermission');

def update(objid,jsonobject):
  Util.pushPathElement('SecurityPermission')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityPermission resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitypermission.specification", None), "specification","SecurityPermission");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitypermission.description", None), "description","SecurityPermission");
  if len(atts) != 0:
    print "Modifying SecurityPermission with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:
    print "SecurityPermission configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'SecurityPermission');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('SecurityPermission');
