from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Service import Service
from utilities import Util
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ServiceContext')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereServiceContext");
  exportedObject.put("roleName", "WebSphereServiceContext");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.servicecontext.name", objid, "name","ServiceContext");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "ServiceContext");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ServiceContext");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));  
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ServiceContext');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ServiceContext')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceContext resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.servicecontext.name", None));
  print "Creating ServiceContext with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ServiceContext", parentid, properties);

  Service.removeServices(objid, 'services', "ServiceContext");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ServiceContext");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);      
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = 0;
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereStateManageable":
        StateManageable.create(objid, curjsonobject);            
  Util.popPathElement('ServiceContext');

def update(objid,jsonobject):
  Util.pushPathElement('ServiceContext')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceContext resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.servicecontext.name", None), "name","ServiceContext");
  if len(atts) != 0:
    print "Modifying ServiceContext with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ServiceContext configuration up to date.";

  Service.removeServices(objid, 'services', "ServiceContext");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ServiceContext");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);        
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = 0;
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole);
      
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereStateManageable":
        StateManageable.create(objid, curjsonobject);               
  Util.popPathElement('ServiceContext');
