from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ThreadPoolRef import ThreadPoolRef;
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TCPOutboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'TCPOutboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTCPOutboundChannel");
  exportedObject.put("roleName", "WebSphereTCPOutboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tcpoutboundchannel.name", objid, "name","TCPOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tcpoutboundchannel.inactivitytimeout", objid, "inactivityTimeout","TCPOutboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'TCPOutboundChannel');
  if threadPool is not None and len(threadPool) > 0:
    threadPoolName = Util.getRequiredAttribute(threadPool, 'name', 'ThreadPool');
    returndict = Util.createTypeFolder(respath, 'ThreadPool', typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ThreadPoolRef._export(currespath, threadPoolName, 'Thread Pool'));

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"TCPOutboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TCPOutboundChannel');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('TCPOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("TCPOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.tcpoutboundchannel.name", None));
  Util.addIfNotNone(properties, "inactivityTimeout", roleProperties.optString("websphere.tcpoutboundchannel.inactivitytimeout", None));
  print "Creating TCPOutboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TCPOutboundChannel", parentid, properties);

  Property.removeProperties(objid, 'properties',"TCPOutboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereThreadPoolRef":
          ThreadPoolRef.create(objid, curjsonobject, 'threadPool', threadPoolLookupPath);
  Util.popPathElement('TCPOutboundChannel');
  return objid;

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('TCPOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("TCPOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tcpoutboundchannel.name", None), "name","TCPOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tcpoutboundchannel.inactivitytimeout", None), "inactivityTimeout","TCPOutboundChannel");
  if len(atts) != 0:
    print "Modifying TCPOutboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TCPOutboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"TCPOutboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereThreadPoolRef":
          ThreadPoolRef.create(objid, curjsonobject, 'threadPool', threadPoolLookupPath);
  Util.popPathElement('TCPOutboundChannel');
