from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASMessageDestinationRefBinding')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASMessageDestinationRefBinding");
  exportedObject.put("roleName", "WebSphereWASMessageDestinationRefBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasmessagedestinationrefbinding.jndiname", objid, "jndiName","WASMessageDestinationRefBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASMessageDestinationRefBinding');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASMessageDestinationRefBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASMessageDestinationRefBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.wasmessagedestinationrefbinding.jndiname", None));
  print "Creating WASMessageDestinationRefBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASMessageDestinationRefBinding", parentid, properties);
  Util.popPathElement('WASMessageDestinationRefBinding');

def update(objid,jsonobject):
  Util.pushPathElement('WASMessageDestinationRefBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASMessageDestinationRefBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasmessagedestinationrefbinding.jndiname", None), "jndiName","WASMessageDestinationRefBinding");
  if len(atts) != 0:
    print "Modifying WASMessageDestinationRefBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASMessageDestinationRefBinding configuration up to date.";

  Util.popPathElement('WASMessageDestinationRefBinding');
