from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSPassword')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSPassword");
  exportedObject.put("roleName", "WebSphereWSPassword");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wspassword.name", objid, "name","WSPassword");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wspassword.keyalias", objid, "keyAlias","WSPassword");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wspassword.encryptedvalue", objid, "encryptedValue","WSPassword");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSPassword');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSPassword')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSPassword resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wspassword.name", None));
  Util.addIfNotNone(properties, "keyAlias", roleProperties.optString("websphere.wspassword.keyalias", None));
  Util.addIfNotNone(properties, "encryptedValue", roleProperties.optString("websphere.wspassword.encryptedvalue", None));
  print "Creating WSPassword with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSPassword", parentid, properties);
  Util.popPathElement('WSPassword');

def update(objid,jsonobject):
  Util.pushPathElement('WSPassword')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSPassword resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wspassword.name", None), "name","WSPassword");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wspassword.keyalias", None), "keyAlias","WSPassword");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wspassword.encryptedvalue", None), "encryptedValue","WSPassword");
  if len(atts) != 0:
    print "Modifying WSPassword with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSPassword configuration up to date.";

  Util.popPathElement('WSPassword');
