from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Archive')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereArchive");
  exportedObject.put("roleName", "WebSphereArchive");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.archive.lastmodified", objid, "lastModified","Archive");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.archive.originaluri", objid, "originalURI","Archive");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.archive.types", objid, "types","Archive");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.archive.directoryentry", objid, "directoryEntry","Archive");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.archive.uri", objid, "URI","Archive");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.archive.size", objid, "size","Archive");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "Archive");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Archive');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Archive')
  if not jsonobject.has("roleProperties"):
    raise Exception("Archive resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.archive.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.archive.originaluri", None));
  Util.addPathProperty(properties, "types", roleProperties.optString("websphere.archive.types", None));
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.archive.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.archive.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.archive.size", None));
  print "Creating Archive with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Archive", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Archive');

def update(objid,jsonobject):
  Util.pushPathElement('Archive')
  if not jsonobject.has("roleProperties"):
    raise Exception("Archive resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.archive.lastmodified", None), "lastModified","Archive");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.archive.originaluri", None), "originalURI","Archive");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.archive.types", None), "types","Archive");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.archive.directoryentry", None), "directoryEntry","Archive");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.archive.uri", None), "URI","Archive");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.archive.size", None), "size","Archive");
  if len(atts) != 0:
    print "Modifying Archive with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Archive configuration up to date.";

  File.removeFiles(objid, 'files',"Archive");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Archive');
