from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('FRCACacheGroupMember')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereFRCACacheGroupMember");
  exportedObject.put("roleName", "WebSphereFRCACacheGroupMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.frcacachegroupmember.transactionclass", objid, "transactionClass","FRCACacheGroupMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.frcacachegroupmember.enablefrca", objid, "enableFRCA","FRCACacheGroupMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.frcacachegroupmember.stackname", objid, "stackName","FRCACacheGroupMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.frcacachegroupmember.maxfilesize", objid, "maxFileSize","FRCACacheGroupMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.frcacachegroupmember.cachesize", objid, "cacheSize","FRCACacheGroupMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('FRCACacheGroupMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('FRCACacheGroupMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("FRCACacheGroupMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "transactionClass", roleProperties.optString("websphere.frcacachegroupmember.transactionclass", None));
  Util.addIfNotNone(properties, "enableFRCA", roleProperties.optString("websphere.frcacachegroupmember.enablefrca", None));
  Util.addIfNotNone(properties, "stackName", roleProperties.optString("websphere.frcacachegroupmember.stackname", None));
  Util.addIfNotNone(properties, "maxFileSize", roleProperties.optString("websphere.frcacachegroupmember.maxfilesize", None));
  Util.addIfNotNone(properties, "cacheSize", roleProperties.optString("websphere.frcacachegroupmember.cachesize", None));
  print "Creating FRCACacheGroupMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("FRCACacheGroupMember", parentid, properties);
  Util.popPathElement('FRCACacheGroupMember');

def update(objid,jsonobject):
  Util.pushPathElement('FRCACacheGroupMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("FRCACacheGroupMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.frcacachegroupmember.transactionclass", None), "transactionClass","FRCACacheGroupMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.frcacachegroupmember.enablefrca", None), "enableFRCA","FRCACacheGroupMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.frcacachegroupmember.stackname", None), "stackName","FRCACacheGroupMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.frcacachegroupmember.maxfilesize", None), "maxFileSize","FRCACacheGroupMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.frcacachegroupmember.cachesize", None), "cacheSize","FRCACacheGroupMember");
  if len(atts) != 0:
    print "Modifying FRCACacheGroupMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "FRCACacheGroupMember configuration up to date.";

  Util.popPathElement('FRCACacheGroupMember');
