from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HTTPQueueInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'HTTPQueueInboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHTTPQueueInboundChannel");
  exportedObject.put("roleName", "WebSphereHTTPQueueInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httpqueueinboundchannel.name", objid, "name","HTTPQueueInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httpqueueinboundchannel.discriminationweight", objid, "discriminationWeight","HTTPQueueInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"HTTPQueueInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HTTPQueueInboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HTTPQueueInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPQueueInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.httpqueueinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.httpqueueinboundchannel.discriminationweight", None));
  print "Creating HTTPQueueInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HTTPQueueInboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HTTPQueueInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('HTTPQueueInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPQueueInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httpqueueinboundchannel.name", None), "name","HTTPQueueInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httpqueueinboundchannel.discriminationweight", None), "discriminationWeight","HTTPQueueInboundChannel");
  if len(atts) != 0:
    print "Modifying HTTPQueueInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HTTPQueueInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"HTTPQueueInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HTTPQueueInboundChannel');
