from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecureAssociationService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecureAssociationService");
  exportedObject.put("roleName", "WebSphereSecureAssociationService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureassociationservice.sessiongcidletime", objid, "sessionGCIdleTime","SecureAssociationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureassociationservice.bootstraprepositorylocation", objid, "bootstrapRepositoryLocation","SecureAssociationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureassociationservice.sessiongcinterval", objid, "sessionGCInterval","SecureAssociationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureassociationservice.stateful", objid, "stateful","SecureAssociationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureassociationservice.securitytagcompatibilitymode", objid, "securityTagCompatibilityMode","SecureAssociationService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecureAssociationService');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecureAssociationService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecureAssociationService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "sessionGCIdleTime", roleProperties.optString("websphere.secureassociationservice.sessiongcidletime", None));
  Util.addIfNotNone(properties, "bootstrapRepositoryLocation", roleProperties.optString("websphere.secureassociationservice.bootstraprepositorylocation", None));
  Util.addIfNotNone(properties, "sessionGCInterval", roleProperties.optString("websphere.secureassociationservice.sessiongcinterval", None));
  Util.addIfNotNone(properties, "stateful", roleProperties.optString("websphere.secureassociationservice.stateful", None));
  Util.addIfNotNone(properties, "securityTagCompatibilityMode", roleProperties.optString("websphere.secureassociationservice.securitytagcompatibilitymode", None));
  print "Creating SecureAssociationService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecureAssociationService", parentid, properties);
  Util.popPathElement('SecureAssociationService');

def update(objid,jsonobject):
  Util.pushPathElement('SecureAssociationService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecureAssociationService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureassociationservice.sessiongcidletime", None), "sessionGCIdleTime","SecureAssociationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureassociationservice.bootstraprepositorylocation", None), "bootstrapRepositoryLocation","SecureAssociationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureassociationservice.sessiongcinterval", None), "sessionGCInterval","SecureAssociationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureassociationservice.stateful", None), "stateful","SecureAssociationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureassociationservice.securitytagcompatibilitymode", None), "securityTagCompatibilityMode","SecureAssociationService");
  if len(atts) != 0:
    print "Modifying SecureAssociationService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SecureAssociationService configuration up to date.";

  Util.popPathElement('SecureAssociationService');
