from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CommonSecureInterop')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCommonSecureInterop");
  exportedObject.put("roleName", "WebSphereCommonSecureInterop");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.commonsecureinterop.sessiongcidletime", objid, "sessionGCIdleTime","CommonSecureInterop");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.commonsecureinterop.sessiongcinterval", objid, "sessionGCInterval","CommonSecureInterop");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.commonsecureinterop.stateful", objid, "stateful","CommonSecureInterop");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CommonSecureInterop');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CommonSecureInterop')
  if not jsonobject.has("roleProperties"):
    raise Exception("CommonSecureInterop resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "sessionGCIdleTime", roleProperties.optString("websphere.commonsecureinterop.sessiongcidletime", None));
  Util.addIfNotNone(properties, "sessionGCInterval", roleProperties.optString("websphere.commonsecureinterop.sessiongcinterval", None));
  Util.addIfNotNone(properties, "stateful", roleProperties.optString("websphere.commonsecureinterop.stateful", None));
  print "Creating CommonSecureInterop with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CommonSecureInterop", parentid, properties);
  Util.popPathElement('CommonSecureInterop');

def update(objid,jsonobject):
  Util.pushPathElement('CommonSecureInterop')
  if not jsonobject.has("roleProperties"):
    raise Exception("CommonSecureInterop resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.commonsecureinterop.sessiongcidletime", None), "sessionGCIdleTime","CommonSecureInterop");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.commonsecureinterop.sessiongcinterval", None), "sessionGCInterval","CommonSecureInterop");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.commonsecureinterop.stateful", None), "stateful","CommonSecureInterop");
  if len(atts) != 0:
    print "Modifying CommonSecureInterop with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CommonSecureInterop configuration up to date.";

  Util.popPathElement('CommonSecureInterop');
