from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DRSSerialization')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDRSSerialization");
  exportedObject.put("roleName", "WebSphereDRSSerialization");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.drsserialization.propertyserializationkind", objid, "propertySerializationKind","DRSSerialization");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.drsserialization.entryserializationkind", objid, "entrySerializationKind","DRSSerialization");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DRSSerialization');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DRSSerialization')
  if not jsonobject.has("roleProperties"):
    raise Exception("DRSSerialization resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "propertySerializationKind", roleProperties.optString("websphere.drsserialization.propertyserializationkind", None));
  Util.addIfNotNone(properties, "entrySerializationKind", roleProperties.optString("websphere.drsserialization.entryserializationkind", None));
  print "Creating DRSSerialization with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DRSSerialization", parentid, properties);
  Util.popPathElement('DRSSerialization');

def update(objid,jsonobject):
  Util.pushPathElement('DRSSerialization')
  if not jsonobject.has("roleProperties"):
    raise Exception("DRSSerialization resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.drsserialization.propertyserializationkind", None), "propertySerializationKind","DRSSerialization");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.drsserialization.entryserializationkind", None), "entrySerializationKind","DRSSerialization");
  if len(atts) != 0:
    print "Modifying DRSSerialization with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DRSSerialization configuration up to date.";

  Util.popPathElement('DRSSerialization');
