from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Filter')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereFilter");
  exportedObject.put("roleName", "WebSphereFilter");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filter.spnegonotsupportedpage", objid, "spnegoNotSupportedPage","Filter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filter.ntlmtokenreceivedpage", objid, "ntlmTokenReceivedPage","Filter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filter.krb5realm", objid, "krb5Realm","Filter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filter.enabledgsscreddelegate", objid, "enabledGssCredDelegate","Filter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filter.trimusername", objid, "trimUserName","Filter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filter.filtercriteria", objid, "filterCriteria","Filter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filter.hostname", objid, "hostName","Filter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.filter.filterclass", objid, "filterClass","Filter");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Filter');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Filter')
  if not jsonobject.has("roleProperties"):
    raise Exception("Filter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "spnegoNotSupportedPage", roleProperties.optString("websphere.filter.spnegonotsupportedpage", None));
  Util.addIfNotNone(properties, "ntlmTokenReceivedPage", roleProperties.optString("websphere.filter.ntlmtokenreceivedpage", None));
  Util.addIfNotNone(properties, "krb5Realm", roleProperties.optString("websphere.filter.krb5realm", None));
  Util.addIfNotNone(properties, "enabledGssCredDelegate", roleProperties.optString("websphere.filter.enabledgsscreddelegate", None));
  Util.addIfNotNone(properties, "trimUserName", roleProperties.optString("websphere.filter.trimusername", None));
  Util.addIfNotNone(properties, "filterCriteria", roleProperties.optString("websphere.filter.filtercriteria", None));
  Util.addIfNotNone(properties, "hostName", roleProperties.optString("websphere.filter.hostname", None));
  Util.addIfNotNone(properties, "filterClass", roleProperties.optString("websphere.filter.filterclass", None));
  print "Creating Filter with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Filter", parentid, properties);
  Util.popPathElement('Filter');

def update(objid,jsonobject):
  Util.pushPathElement('Filter')
  if not jsonobject.has("roleProperties"):
    raise Exception("Filter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filter.spnegonotsupportedpage", None), "spnegoNotSupportedPage","Filter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filter.ntlmtokenreceivedpage", None), "ntlmTokenReceivedPage","Filter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filter.krb5realm", None), "krb5Realm","Filter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filter.enabledgsscreddelegate", None), "enabledGssCredDelegate","Filter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filter.trimusername", None), "trimUserName","Filter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filter.filtercriteria", None), "filterCriteria","Filter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filter.hostname", None), "hostName","Filter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.filter.filterclass", None), "filterClass","Filter");
  if len(atts) != 0:
    print "Modifying Filter with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Filter configuration up to date.";

  Util.popPathElement('Filter');
