from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GenericChannelData')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericChannelData");
  exportedObject.put("roleName", "WebSphereGenericChannelData");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericchanneldata.typeid", objid, "typeID","GenericChannelData");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericchanneldata.configuri", objid, "configURI","GenericChannelData");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericchanneldata.jarfile", objid, "jarFile","GenericChannelData");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericChannelData');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericChannelData')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericChannelData resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "typeID", roleProperties.optString("websphere.genericchanneldata.typeid", None));
  Util.addIfNotNone(properties, "configURI", roleProperties.optString("websphere.genericchanneldata.configuri", None));
  Util.addIfNotNone(properties, "jarFile", roleProperties.optString("websphere.genericchanneldata.jarfile", None));
  print "Creating GenericChannelData with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericChannelData", parentid, properties);
  Util.popPathElement('GenericChannelData');

def update(objid,jsonobject):
  Util.pushPathElement('GenericChannelData')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericChannelData resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericchanneldata.typeid", None), "typeID","GenericChannelData");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericchanneldata.configuri", None), "configURI","GenericChannelData");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericchanneldata.jarfile", None), "jarFile","GenericChannelData");
  if len(atts) != 0:
    print "Modifying GenericChannelData with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericChannelData configuration up to date.";

  Util.popPathElement('GenericChannelData');
