from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Identity')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereIdentity");
  exportedObject.put("roleName", "WebSphereIdentity");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.identity.rolename", objid, "roleName","Identity");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.identity.description", objid, "description","Identity");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'Identity');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Identity');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Identity')
  if not jsonobject.has("roleProperties"):
    raise Exception("Identity resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "roleName", roleProperties.optString("websphere.identity.rolename", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.identity.description", None));
  print "Creating Identity with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Identity", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('Identity');

def update(objid,jsonobject):
  Util.pushPathElement('Identity')
  if not jsonobject.has("roleProperties"):
    raise Exception("Identity resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.identity.rolename", None), "roleName","Identity");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.identity.description", None), "description","Identity");
  if len(atts) != 0:
    print "Modifying Identity with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Identity configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'Identity');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('Identity');
