from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ManagedMiddlewareAppEdition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereManagedMiddlewareAppEdition");
  exportedObject.put("roleName", "WebSphereManagedMiddlewareAppEdition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.managedmiddlewareappedition.name", objid, "name","ManagedMiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.managedmiddlewareappedition.alias", objid, "alias","ManagedMiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.managedmiddlewareappedition.description", objid, "description","ManagedMiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.managedmiddlewareappedition.state", objid, "state","ManagedMiddlewareAppEdition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.managedmiddlewareappedition.archivename", objid, "archiveName","ManagedMiddlewareAppEdition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ManagedMiddlewareAppEdition");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ManagedMiddlewareAppEdition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ManagedMiddlewareAppEdition')
  if not jsonobject.has("roleProperties"):
    raise Exception("ManagedMiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.managedmiddlewareappedition.name", None));
  Util.addIfNotNone(properties, "alias", roleProperties.optString("websphere.managedmiddlewareappedition.alias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.managedmiddlewareappedition.description", None));
  Util.addIfNotNone(properties, "state", roleProperties.optString("websphere.managedmiddlewareappedition.state", None));
  Util.addIfNotNone(properties, "archiveName", roleProperties.optString("websphere.managedmiddlewareappedition.archivename", None));
  print "Creating ManagedMiddlewareAppEdition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ManagedMiddlewareAppEdition", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ManagedMiddlewareAppEdition');

def update(objid,jsonobject):
  Util.pushPathElement('ManagedMiddlewareAppEdition')
  if not jsonobject.has("roleProperties"):
    raise Exception("ManagedMiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.managedmiddlewareappedition.name", None), "name","ManagedMiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.managedmiddlewareappedition.alias", None), "alias","ManagedMiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.managedmiddlewareappedition.description", None), "description","ManagedMiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.managedmiddlewareappedition.state", None), "state","ManagedMiddlewareAppEdition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.managedmiddlewareappedition.archivename", None), "archiveName","ManagedMiddlewareAppEdition");
  if len(atts) != 0:
    print "Modifying ManagedMiddlewareAppEdition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ManagedMiddlewareAppEdition configuration up to date.";

  Property.removeProperties(objid, 'properties',"ManagedMiddlewareAppEdition");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ManagedMiddlewareAppEdition');
