from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MonitoringPolicy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMonitoringPolicy");
  exportedObject.put("roleName", "WebSphereMonitoringPolicy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.monitoringpolicy.maximumstartupattempts", objid, "maximumStartupAttempts","MonitoringPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.monitoringpolicy.pingtimeout", objid, "pingTimeout","MonitoringPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.monitoringpolicy.pinginterval", objid, "pingInterval","MonitoringPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.monitoringpolicy.noderestartstate", objid, "nodeRestartState","MonitoringPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.monitoringpolicy.autorestart", objid, "autoRestart","MonitoringPolicy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MonitoringPolicy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MonitoringPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("MonitoringPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maximumStartupAttempts", roleProperties.optString("websphere.monitoringpolicy.maximumstartupattempts", None));
  Util.addIfNotNone(properties, "pingTimeout", roleProperties.optString("websphere.monitoringpolicy.pingtimeout", None));
  Util.addIfNotNone(properties, "pingInterval", roleProperties.optString("websphere.monitoringpolicy.pinginterval", None));
  Util.addIfNotNone(properties, "nodeRestartState", roleProperties.optString("websphere.monitoringpolicy.noderestartstate", None));
  Util.addIfNotNone(properties, "autoRestart", roleProperties.optString("websphere.monitoringpolicy.autorestart", None));
  print "Creating MonitoringPolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MonitoringPolicy", parentid, properties);
  Util.popPathElement('MonitoringPolicy');

def update(objid,jsonobject):
  Util.pushPathElement('MonitoringPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("MonitoringPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.monitoringpolicy.maximumstartupattempts", None), "maximumStartupAttempts","MonitoringPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.monitoringpolicy.pingtimeout", None), "pingTimeout","MonitoringPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.monitoringpolicy.pinginterval", None), "pingInterval","MonitoringPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.monitoringpolicy.noderestartstate", None), "nodeRestartState","MonitoringPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.monitoringpolicy.autorestart", None), "autoRestart","MonitoringPolicy");
  if len(atts) != 0:
    print "Modifying MonitoringPolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MonitoringPolicy configuration up to date.";

  Util.popPathElement('MonitoringPolicy');
