from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Service import Service
from Component import Component
from Property import Property
from utilities import Util
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PortletContainer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePortletContainer");
  exportedObject.put("roleName", "WebSpherePortletContainer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.portletcontainer.name", objid, "name","PortletContainer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.portletcontainer.enableportletcaching", objid, "enablePortletCaching","PortletContainer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.portletcontainer.maxprocesseventcount", objid, "maxProcessEventCount","PortletContainer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"PortletContainer");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "PortletContainer");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "PortletContainer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"PortletContainer");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable")); 
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PortletContainer');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('PortletContainer')
  if not jsonobject.has("roleProperties"):
    raise Exception("PortletContainer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.portletcontainer.name", None));
  Util.addIfNotNone(properties, "enablePortletCaching", roleProperties.optString("websphere.portletcontainer.enableportletcaching", None));
  Util.addIfNotNone(properties, "maxProcessEventCount", roleProperties.optString("websphere.portletcontainer.maxprocesseventcount", None));
  print "Creating PortletContainer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PortletContainer", parentid, properties);

  Component.removeComponents(objid, 'components', "PortletContainer");
  Service.removeServices(objid, 'services', "PortletContainer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"PortletContainer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);     
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('PortletContainer');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('PortletContainer')
  if not jsonobject.has("roleProperties"):
    raise Exception("PortletContainer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.portletcontainer.name", None), "name","PortletContainer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.portletcontainer.enableportletcaching", None), "enablePortletCaching","PortletContainer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.portletcontainer.maxprocesseventcount", None), "maxProcessEventCount","PortletContainer");
  if len(atts) != 0:
    print "Modifying PortletContainer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PortletContainer configuration up to date.";

  Property.removeProperties(objid, 'properties',"PortletContainer");
  Component.removeComponents(objid, 'components', "PortletContainer");
  Service.removeServices(objid, 'services', "PortletContainer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"PortletContainer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);   
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
  Util.popPathElement('PortletContainer');
