from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthGroupRef import SIBAuthGroupRef;
from SIBAuthUserRef import SIBAuthUserRef;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthReceiver')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthReceiver");
  exportedObject.put("roleName", "WebSphereSIBAuthReceiver");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  groups = Util.parseConfigIdListAttribute(objid, 'group', 'SIBAuthReceiver');
  for group in groups:
    if len(group) > 0:
      returndict = Util.createTypeFolder(respath, "SIBAuthGroupRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBAuthGroupRef._export(group, currespath, "SIBAuthGroupRef%s" % i));
      i = i + 1;

  i = 0;
  users = Util.parseConfigIdListAttribute(objid, 'user', 'SIBAuthReceiver');
  for user in users:
    if len(user) > 0:
      returndict = Util.createTypeFolder(respath, "SIBAuthUserRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBAuthUserRef._export(user, currespath, "SIBAuthUserRef%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthReceiver');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthReceiver')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthReceiver resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating SIBAuthReceiver with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthReceiver", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthGroupRef":
        SIBAuthGroupRef.create(objid, curjsonobject, 'group');
      elif currole == "WebSphereSIBAuthUserRef":
        SIBAuthUserRef.create(objid, curjsonobject, 'user');

  Util.popPathElement('SIBAuthReceiver');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthReceiver')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthReceiver resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying SIBAuthReceiver with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthReceiver configuration up to date.";

  Util.unsetAttribute(objid, "group", "SIBAuthReceiver");
  Util.unsetAttribute(objid, "user", "SIBAuthReceiver");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthGroupRef":
        SIBAuthGroupRef.create(objid, curjsonobject, 'group');
      elif currole == "WebSphereSIBAuthUserRef":
        SIBAuthUserRef.create(objid, curjsonobject, 'user');

  Util.popPathElement('SIBAuthReceiver');
