from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQMediationPointProxy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQMediationPointProxy");
  exportedObject.put("roleName", "WebSphereSIBMQMediationPointProxy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqmediationpointproxy.inboundpersistentreliability", objid, "inboundPersistentReliability","SIBMQMediationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqmediationpointproxy.enablerfh2header", objid, "enableRFH2Header","SIBMQMediationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqmediationpointproxy.identifier", objid, "identifier","SIBMQMediationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqmediationpointproxy.uuid", objid, "uuid","SIBMQMediationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqmediationpointproxy.inboundnonpersistentreliability", objid, "inboundNonPersistentReliability","SIBMQMediationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqmediationpointproxy.targetuuid", objid, "targetUuid","SIBMQMediationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqmediationpointproxy.mqqueuename", objid, "mqQueueName","SIBMQMediationPointProxy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQMediationPointProxy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMQMediationPointProxy')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQMediationPointProxy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inboundPersistentReliability", roleProperties.optString("websphere.sibmqmediationpointproxy.inboundpersistentreliability", None));
  Util.addIfNotNone(properties, "enableRFH2Header", roleProperties.optString("websphere.sibmqmediationpointproxy.enablerfh2header", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibmqmediationpointproxy.identifier", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibmqmediationpointproxy.uuid", None));
  Util.addIfNotNone(properties, "inboundNonPersistentReliability", roleProperties.optString("websphere.sibmqmediationpointproxy.inboundnonpersistentreliability", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.sibmqmediationpointproxy.targetuuid", None));
  Util.addIfNotNone(properties, "mqQueueName", roleProperties.optString("websphere.sibmqmediationpointproxy.mqqueuename", None));
  print "Creating SIBMQMediationPointProxy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQMediationPointProxy", parentid, properties);
  Util.popPathElement('SIBMQMediationPointProxy');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMQMediationPointProxy')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQMediationPointProxy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqmediationpointproxy.inboundpersistentreliability", None), "inboundPersistentReliability","SIBMQMediationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqmediationpointproxy.enablerfh2header", None), "enableRFH2Header","SIBMQMediationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqmediationpointproxy.identifier", None), "identifier","SIBMQMediationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqmediationpointproxy.uuid", None), "uuid","SIBMQMediationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqmediationpointproxy.inboundnonpersistentreliability", None), "inboundNonPersistentReliability","SIBMQMediationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqmediationpointproxy.targetuuid", None), "targetUuid","SIBMQMediationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqmediationpointproxy.mqqueuename", None), "mqQueueName","SIBMQMediationPointProxy");
  if len(atts) != 0:
    print "Modifying SIBMQMediationPointProxy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQMediationPointProxy configuration up to date.";

  Util.popPathElement('SIBMQMediationPointProxy');
