/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import com.urbancode.commons.httpcomponentsutil.ConnectionCleaner;
import com.urbancode.commons.httpcomponentsutil.FlexibleSSLSocketFactory;
import com.urbancode.commons.httpcomponentsutil.SharedConnectionCleaner;
import com.urbancode.commons.httpcomponentsutil.TimeoutHelper;
import com.urbancode.commons.util.ssl.OpenX509TrustManager;
import com.urbancode.commons.util.ssl.SSLContextProtocolDetector;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.protocol.HttpContext;

public class CloseableHttpClientBuilder {
    private boolean trustAllCerts = false;
    private int timeoutMillis = -1;
    private String username = null;
    private String password = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private boolean preemptiveAuthentication = false;
    private int maxConnsPerRoute = -1;
    private int maxConns = -1;
    private long idleConnectionTimeout = 30000L;
    private KeyManager[] keyManagers;
    private X509HostnameVerifier hostnameVerifier;
    private boolean useSharedIdleConnectionCleaner = true;
    HttpClientConnectionManager connectionManager = null;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public void setKeyManagers(KeyManager ... keyManagers) {
        if (keyManagers != null) {
            keyManagers = (KeyManager[])keyManagers.clone();
        }
        this.keyManagers = keyManagers;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setConnectionManager(HttpClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        if (connectionManager != null) {
            this.maxConnsPerRoute = -1;
            this.maxConns = -1;
        }
    }

    public void setMaxConnsPerRoute(int maxConnsPerRoute) {
        this.connectionManager = null;
        this.maxConnsPerRoute = maxConnsPerRoute;
    }

    public void setMaxConns(int maxConns) {
        this.connectionManager = null;
        this.maxConns = maxConns;
    }

    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }

    public void setIdleConnectionTimeout(long idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public void setUseSharedIdleConnectionCleaner(boolean useSharedIdleConnectionCleaner) {
        this.useSharedIdleConnectionCleaner = useSharedIdleConnectionCleaner;
    }

    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public HttpClientBuilder buildClientBuilder() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (this.connectionManager == null) {
            int maxConnsPerRoute = this.maxConnsPerRoute;
            int maxConns = this.maxConns;
            if (maxConnsPerRoute < 0) {
                maxConnsPerRoute = 50;
            }
            if (maxConns < 0) {
                maxConns = 100;
            }
            if (maxConns < maxConnsPerRoute) {
                maxConns = maxConnsPerRoute;
            }
            clientBuilder.setMaxConnPerRoute(maxConnsPerRoute);
            clientBuilder.setMaxConnTotal(maxConns);
            clientBuilder.setSSLSocketFactory(this.buildSocketFactory());
        } else {
            clientBuilder.setConnectionManager(this.connectionManager);
        }
        clientBuilder.setRedirectStrategy(new DefaultRedirectStrategy());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            clientBuilder.setProxy(proxy);
            if (StringUtils.isNotEmpty(this.proxyUsername)) {
                ProxyAuthenticationStrategy strat = new ProxyAuthenticationStrategy();
                clientBuilder.setProxyAuthenticationStrategy(strat);
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                credsProvider.setCredentials(new AuthScope(this.proxyHost, this.proxyPort), proxyCredentials);
            }
        }
        if (this.username != null && this.password != null) {
            UsernamePasswordCredentials clientCredentials = new UsernamePasswordCredentials(this.username, this.password);
            credsProvider.setCredentials(AuthScope.ANY, clientCredentials);
        }
        clientBuilder.setDefaultCredentialsProvider(credsProvider);
        int timeout = new TimeoutHelper().getTimeout(this.timeoutMillis);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setStaleConnectionCheckEnabled(true).build();
        clientBuilder.setDefaultRequestConfig(defaultRequestConfig);
        SocketConfig.Builder socketConfig = SocketConfig.custom().setSoReuseAddress(true).setSoKeepAlive(true).setTcpNoDelay(true);
        if (timeout > 0) {
            socketConfig.setSoTimeout(timeout);
        }
        clientBuilder.setDefaultSocketConfig(socketConfig.build());
        if (this.preemptiveAuthentication) {
            clientBuilder.addInterceptorFirst(new PreemptiveAuthInterceptor());
        }
        if (this.connectionManager != null) {
            clientBuilder.addInterceptorFirst(new ApplySSLSocketFactory(this.buildSocketFactory()));
        }
        return clientBuilder;
    }

    public CloseableHttpClient buildClient() {
        CloseableHttpClient client = this.buildClientBuilder().build();
        if (this.idleConnectionTimeout > 0L) {
            if (this.useSharedIdleConnectionCleaner) {
                SharedConnectionCleaner.track(client, this.idleConnectionTimeout);
            } else {
                new ConnectionCleaner(client, this.idleConnectionTimeout).start();
            }
        }
        return client;
    }

    private SSLConnectionSocketFactory buildSocketFactory() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance(SSLContextProtocolDetector.detectSslContextProtocol());
            KeyManager[] km = this.keyManagers;
            TrustManager[] tm = null;
            if (this.trustAllCerts) {
                tm = new TrustManager[]{new OpenX509TrustManager()};
            }
            sslContext.init(km, tm, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLSocketFactory factory = sslContext.getSocketFactory();
        String[] supportedProtocols = sslContext.createSSLEngine().getSupportedProtocols();
        FlexibleSSLSocketFactory flexibleSSLSocketFactory = new FlexibleSSLSocketFactory(factory, supportedProtocols);
        X509HostnameVerifier hostNameVerifier = this.hostnameVerifier;
        if (hostNameVerifier == null && this.trustAllCerts) {
            hostNameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        }
        return new SSLConnectionSocketFactory(flexibleSSLSocketFactory, hostNameVerifier);
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        public void process(HttpRequest request, HttpContext oldContext) throws HttpException, IOException {
            HttpHost targetHost;
            CredentialsProvider credsProvider;
            Credentials creds;
            HttpClientContext context = HttpClientContext.adapt(oldContext);
            AuthState authState = context.getTargetAuthState();
            if (authState.getAuthScheme() == null && (creds = (credsProvider = context.getCredentialsProvider()).getCredentials(new AuthScope((targetHost = context.getTargetHost()).getHostName(), targetHost.getPort()))) != null) {
                authState.setState(AuthProtocolState.CHALLENGED);
                authState.update(new BasicScheme(), creds);
            }
        }
    }

    static class ApplySSLSocketFactory
    implements HttpRequestInterceptor {
        Registry<ConnectionSocketFactory> registry;

        public ApplySSLSocketFactory(SSLConnectionSocketFactory sslSocketFactory) {
            this.registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        }

        public void process(HttpRequest request, HttpContext oldContext) throws HttpException, IOException {
            HttpClientContext context = HttpClientContext.adapt(oldContext);
            if (context.getAttribute("http.socket-factory-registry") == null) {
                context.setAttribute("http.socket-factory-registry", this.registry);
            }
        }
    }
}

