from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.deployedmiddlewareapp.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'DeployedMiddlewareApp');

  containmentpath = "%(parentconpath)sDeployedMiddlewareApp:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('DeployedMiddlewareApp')

  name = Util.getRequiredAttribute(objid, "name", 'DeployedMiddlewareApp');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDeployedMiddlewareApp");
  exportedObject.put("roleName", "WebSphereDeployedMiddlewareApp");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.deployedmiddlewareapp.name", objid, "name","DeployedMiddlewareApp");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DeployedMiddlewareApp");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DeployedMiddlewareApp');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedMiddlewareApp resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.deployedmiddlewareapp.name"):
    raise Exception("Resource role properties does not contain websphere.deployedmiddlewareapp.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create DeployedMiddlewareApp on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('DeployedMiddlewareApp')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedMiddlewareApp resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.deployedmiddlewareapp.name"):
    raise Exception("Resource role properties does not contain websphere.deployedmiddlewareapp.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.deployedmiddlewareapp.name", None));
  print "Creating DeployedMiddlewareApp with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DeployedMiddlewareApp", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DeployedMiddlewareApp');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('DeployedMiddlewareApp')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedMiddlewareApp resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.deployedmiddlewareapp.name"):
    raise Exception("Resource role properties does not contain websphere.deployedmiddlewareapp.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.deployedmiddlewareapp.name", None), "name","DeployedMiddlewareApp");
  if len(atts) != 0:
    print "Modifying DeployedMiddlewareApp with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DeployedMiddlewareApp configuration up to date.";

  Property.removeProperties(objid, 'properties',"DeployedMiddlewareApp");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('DeployedMiddlewareApp');
