from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HPELTrace')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHPELTrace");
  exportedObject.put("roleName", "WebSphereHPELTrace");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.outofspaceaction", objid, "outOfSpaceAction","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.bufferingenabled", objid, "bufferingEnabled","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.purgemaxsize", objid, "purgeMaxSize","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.datadirectory", objid, "dataDirectory","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.fileswitchenabled", objid, "fileSwitchEnabled","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.storagetype", objid, "storageType","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.memorybuffersize", objid, "memoryBufferSize","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.purgemintime", objid, "purgeMinTime","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.fileswitchtime", objid, "fileSwitchTime","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.purgebysizeenabled", objid, "purgeBySizeEnabled","HPELTrace");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltrace.purgebytimeenabled", objid, "purgeByTimeEnabled","HPELTrace");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HPELTrace');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HPELTrace')
  if not jsonobject.has("roleProperties"):
    raise Exception("HPELTrace resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "outOfSpaceAction", roleProperties.optString("websphere.hpeltrace.outofspaceaction", None));
  Util.addIfNotNone(properties, "bufferingEnabled", roleProperties.optString("websphere.hpeltrace.bufferingenabled", None));
  Util.addIfNotNone(properties, "purgeMaxSize", roleProperties.optString("websphere.hpeltrace.purgemaxsize", None));
  Util.addIfNotNone(properties, "dataDirectory", roleProperties.optString("websphere.hpeltrace.datadirectory", None));
  Util.addIfNotNone(properties, "fileSwitchEnabled", roleProperties.optString("websphere.hpeltrace.fileswitchenabled", None));
  Util.addIfNotNone(properties, "storageType", roleProperties.optString("websphere.hpeltrace.storagetype", None));
  Util.addIfNotNone(properties, "memoryBufferSize", roleProperties.optString("websphere.hpeltrace.memorybuffersize", None));
  Util.addIfNotNone(properties, "purgeMinTime", roleProperties.optString("websphere.hpeltrace.purgemintime", None));
  Util.addIfNotNone(properties, "fileSwitchTime", roleProperties.optString("websphere.hpeltrace.fileswitchtime", None));
  Util.addIfNotNone(properties, "purgeBySizeEnabled", roleProperties.optString("websphere.hpeltrace.purgebysizeenabled", None));
  Util.addIfNotNone(properties, "purgeByTimeEnabled", roleProperties.optString("websphere.hpeltrace.purgebytimeenabled", None));
  print "Creating HPELTrace with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HPELTrace", parentid, properties);
  Util.popPathElement('HPELTrace');

def update(objid,jsonobject):
  Util.pushPathElement('HPELTrace')
  if not jsonobject.has("roleProperties"):
    raise Exception("HPELTrace resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.outofspaceaction", None), "outOfSpaceAction","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.bufferingenabled", None), "bufferingEnabled","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.purgemaxsize", None), "purgeMaxSize","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.datadirectory", None), "dataDirectory","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.fileswitchenabled", None), "fileSwitchEnabled","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.storagetype", None), "storageType","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.memorybuffersize", None), "memoryBufferSize","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.purgemintime", None), "purgeMinTime","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.fileswitchtime", None), "fileSwitchTime","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.purgebysizeenabled", None), "purgeBySizeEnabled","HPELTrace");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltrace.purgebytimeenabled", None), "purgeByTimeEnabled","HPELTrace");
  if len(atts) != 0:
    print "Modifying HPELTrace with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HPELTrace configuration up to date.";

  Util.popPathElement('HPELTrace');
