from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JFAPInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'JFAPInboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJFAPInboundChannel");
  exportedObject.put("roleName", "WebSphereJFAPInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jfapinboundchannel.name", objid, "name","JFAPInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jfapinboundchannel.discriminationweight", objid, "discriminationWeight","JFAPInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jfapinboundchannel.heartbeattimeout", objid, "heartbeatTimeout","JFAPInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jfapinboundchannel.heartbeatinterval", objid, "heartbeatInterval","JFAPInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"JFAPInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JFAPInboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JFAPInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("JFAPInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jfapinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.jfapinboundchannel.discriminationweight", None));
  Util.addIfNotNone(properties, "heartbeatTimeout", roleProperties.optString("websphere.jfapinboundchannel.heartbeattimeout", None));
  Util.addIfNotNone(properties, "heartbeatInterval", roleProperties.optString("websphere.jfapinboundchannel.heartbeatinterval", None));
  print "Creating JFAPInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JFAPInboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JFAPInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('JFAPInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("JFAPInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jfapinboundchannel.name", None), "name","JFAPInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jfapinboundchannel.discriminationweight", None), "discriminationWeight","JFAPInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jfapinboundchannel.heartbeattimeout", None), "heartbeatTimeout","JFAPInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jfapinboundchannel.heartbeatinterval", None), "heartbeatInterval","JFAPInboundChannel");
  if len(atts) != 0:
    print "Modifying JFAPInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JFAPInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"JFAInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JFAPInboundChannel');
